#include <iostream>
#include <fstream>
#include <cmath>
#include <set>
#include <map>
#include <queue>
#include <vector>
#include <algorithm>
using namespace std;
#define int long long
#define ll long long
#define pi pair<int, int>
#define ld long double
#pragma GCC optimize(3)
const int MOD = 998244353;
const int maxN = 4005;
vector<int> fac;
vector<int> revfac;
int bpow(int num, int k) {
    if(k == 0) return 1;
    int t = bpow(num, k / 2);
    t *= t; t %= MOD;
    if(k % 2) {
        t *= num; t %= MOD;
    }
    return t;
}

void precalc() {
    fac.assign(maxN, 1);
    revfac.assign(maxN, 1);
    for(int i = 2; i < maxN; ++i) {
        fac[i] = fac[i - 1] * i; fac[i] %= MOD;
        revfac[i] = bpow(fac[i], MOD - 2);
    }
}

int C(int N, int K) {
    int tmp = fac[N]; tmp *= revfac[K]; tmp %= MOD;
    tmp *= revfac[N - K]; tmp %= MOD;
    return tmp;
}

vector<int> id;
vector<vector<int>> segs;

bool cmp1(int i, int j) {
    if(i == j) return false;
    int x1 = segs[i][2] - segs[i][0]; int y1 = segs[i][3] - segs[i][1];
    int x2 = segs[j][2] - segs[j][0]; int y2 = segs[j][3] - segs[j][1];
    return y1 * x2 < x1 * y2;
}
int vmnozh(pi& p1, pi& p2) {
    return p1.first * p2.second - p2.first * p1.second;
}
int sgn(int a) {
    if(a < 0) return -1;
    if(a == 0) return 0;
    return 1;
}

int intee(int i, int j) {
    pi p1 = {segs[i][2] - segs[i][0], segs[i][3] - segs[i][1]};
    pi p2 = {segs[j][0] - segs[i][0], segs[j][1] - segs[i][1]};
    pi p3 = {segs[j][2] - segs[i][0], segs[j][3] - segs[i][1]};
    return abs(vmnozh(p1, p2)) + abs(vmnozh(p1, p3));
}
bool dd(int i, int j) {
    pi p1 = {segs[i][2] - segs[i][0], segs[i][3] - segs[i][1]};
    pi p2 = {segs[j][0] - segs[i][0], segs[j][1] - segs[i][1]};
    pi p3 = {segs[j][2] - segs[i][0], segs[j][3] - segs[i][1]};
    return sgn(vmnozh(p1, p2)) != sgn(vmnozh(p1, p3));
}
bool inter(int i, int j) {
    if(segs[i][0] == segs[j][0] && segs[i][1] == segs[j][1]) return true;
    if(segs[i][0] == segs[j][2] && segs[i][1] == segs[j][3]) return true;
    if(segs[i][2] == segs[j][0] && segs[i][3] == segs[j][1]) return true;
    if(segs[i][2] == segs[j][2] && segs[i][3] == segs[j][3]) return true;
    if(intee(i, j) != intee(j, i)) return false;
    if(!dd(i, j)) return false;
    return true;
}
vector<int> p;
int getP(int a) {
    if(p[a] == a) return a;
    p[a] = getP(p[a]);
    return p[a];
}
void unite(int a, int b) {
    int p1 = getP(a); int p2 = getP(b);
    p[p1] = p2;
}
ld get(int i, int j) {
    if(segs[i][0] == segs[j][0] && segs[i][1] == segs[j][1]) return segs[j][1];
    if(segs[i][0] == segs[j][2] && segs[i][1] == segs[j][3]) return segs[j][3];
    if(segs[i][2] == segs[j][0] && segs[i][3] == segs[j][1]) return segs[j][1];
    if(segs[i][2] == segs[j][2] && segs[i][3] == segs[j][3]) return segs[j][3];
    if(segs[i][0] == segs[i][2]) {
        ld k2 = segs[j][3] - segs[j][1]; k2 /= (segs[j][2] - segs[j][0]);
        ld b2 = segs[j][1] - k2 * segs[j][0];
        return k2 * segs[i][0] + b2;
    }
    if(segs[j][0] == segs[j][2]) {
        ld k1 = segs[i][3] - segs[i][1]; k1 /= (segs[i][2] - segs[i][0]);
        ld b = segs[i][1] - k1 * segs[i][0];
        return k1 * segs[j][0] + b;
    }
    ld k1 = segs[i][3] - segs[i][1]; k1 /= (segs[i][2] - segs[i][0]);
    ld k2 = segs[j][3] - segs[j][1]; k2 /= (segs[j][2] - segs[j][0]);
    ld b = segs[i][1] - k1 * segs[i][0]; ld b2 = segs[j][1] - k2 * segs[j][0];
    b -= b2;
    b /= (k2 - k1);
    return k2 * b + b2;
}

void solve() {
    int N = 0; cin >> N;
    segs.assign(N, vector<int> (4, 0));
    for(int i = 0; i < N; ++i) {
        for(int j = 0; j < 4; ++j) {
            cin >> segs[i][j];
        }
        if(segs[i][0] > segs[i][2]) {
            swap(segs[i][0], segs[i][2]);
            swap(segs[i][1], segs[i][3]);
        }
        if(segs[i][0] == segs[i][2]) {
            if(segs[i][1] > segs[i][3]) swap(segs[i][1], segs[i][3]);
        }
    }
    id.assign(N, 0);
    for(int i = 0; i < N; ++i) id[i] = i;
    sort(id.begin(), id.end(), cmp1);
    int ans = 0;
    p.assign(N, 0);
    for(int i = 0; i < N; ++i) p[i] = i;
    for(int i = 0; i < N; ++i) {
        for(int j = i - 1; j >= 0; --j) {
            if(inter(id[i], id[j])) {
                if(getP(id[i]) == getP(id[j])) ans++;
                else unite(id[i], id[j]);
            }
        }
    }
    cout << ans + 1 << endl;
}

signed main() {
    cin.tie(nullptr);
    cout.tie(nullptr);
    ios_base::sync_with_stdio(false);
    int T = 1;
    cin >> T;
    while(T--) {
        solve();
    }
}
/*
9 6 3 2 0 0
*/
